//
//  OPAttachment.h
//  OnePasswordiOS
//
//  Created by Roustem Karimov on 12-02-19.
//  Copyright (c) 2012 AgileBits. All rights reserved.
//

#import "OPDatabaseObjectWithOverview.h"

@class OPItem;

@interface OPItemAttachment : OPDatabaseObjectWithOverview <OPDisplayOrderable, OPSyncable, NSSecureCoding>

@property (nonatomic, weak) OPItem * item;
@property (nonatomic) OPID itemOid;
@property (nonatomic, strong) NSData * contents;
@property (nonatomic, strong) NSString * filename;
@property (nonatomic, strong) NSURL * externalFileURL;
@property (nonatomic, strong) NSURL * unencryptedFileURL;

@property (nonatomic, readonly) NSData * iconData;
@property (nonatomic, strong) OPImage * iconImage;

// database properties

@property (nonatomic, strong) NSString * uuid;
@property (nonatomic, getter = isExternal) BOOL external;
@property (nonatomic) NSUInteger displayOrder;
@property (nonatomic) int64_t contentsSize;
@property (nonatomic, strong) NSData * encryptedContents;
@property (nonatomic, strong) NSData * encryptedIcon;
@property (nonatomic) OPTimestamp createdAt;
@property (nonatomic) OPTimestamp updatedAt;

+ (BOOL)mustUseExternalStorageForContentsOfLength:(uint64_t)length;
+ (OPItemAttachment *)attachmentForItem:(OPItem *)item withDict:(NSDictionary *)dict;
+ (OPItemAttachment *)unencryptedAttachmentForItem:(OPItem *)item withURL:(NSURL *)url;

- (BOOL)writeEncryptedContentsUsingBlock:(void (^)(NSFileHandle *outFile))writer;
- (void)readEncryptedContentsUsingBlock:(void (^)(NSFileHandle *inFile))reader;

@end

